FirstPersonOnly = {}

-- Funktion zum Erzwingen der First-Person-Ansicht
local function setFirstPersonCamera(vehicle)
    if vehicle.spec_enterable ~= nil and vehicle.spec_enterable.cameras ~= nil then
        for i, camera in ipairs(vehicle.spec_enterable.cameras) do
            if camera.isInside then
                vehicle.spec_enterable:setActiveCameraIndex(i)
                break
            end
        end
    end
end

-- Funktion wird aufgerufen, wenn der Spieler das Fahrzeug betritt
function FirstPersonOnly:onEnterVehicleFinished(vehicle, isControlling)
    if isControlling then
        setFirstPersonCamera(vehicle)
    end
end

-- Key-Event-Handler um die `C`-Taste (Kamerawechsel) zu blockieren
function FirstPersonOnly:keyEvent(unicode, sym, modifier, isDown)
    -- Wenn die `C`-Taste gedrückt wird, blockieren
    if sym == Input.KEY_c and isDown then
        return true  -- `true` bedeutet, dass der Event blockiert wird
    end
end

-- Initialisierung der Mod
function FirstPersonOnly:loadMap(name)
end

function FirstPersonOnly:deleteMap()
end

function FirstPersonOnly:mouseEvent(posX, posY, isDown, isUp, button)
end

function FirstPersonOnly:update(dt)
end

function FirstPersonOnly:draw()
end

addModEventListener(FirstPersonOnly)

-- Reagiert auf den Fahrzeug-Einstieg und stellt sicher, dass die Kamera richtig gesetzt wird
VehicleEnterResponseEvent = VehicleEnterResponseEvent or {}
local oldVehicleEnterResponseRun = VehicleEnterResponseEvent.run
function VehicleEnterResponseEvent:run(connection)
    if oldVehicleEnterResponseRun ~= nil then
        oldVehicleEnterResponseRun(self, connection)
    end

    if g_currentMission.controlledVehicle ~= nil then
        setFirstPersonCamera(g_currentMission.controlledVehicle)
    end
end
